<?php

class ClaimuploadsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/column2';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl', // perform access control for CRUD operations
			'postOnly + delete', // we only allow deletion via POST request
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}
 
 
	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	  
	public function actionCreate()
	{
		$model=new Claimuploads;
		$model=new Claimuploads;
		$mode=new Claimuploads;
		$c = new CDbCriteria;
		$c->compare('claim_id',$_REQUEST['Claim_id']);
		$df = $mode->find($c);
		$size=5*1024*1024;
		// Uncomment the following line if AJAX validation is needed
		/* $this->performAjaxValidation($model);
		Yii::log("actionCreate actionCreate "  
		isset($_POST['Claimuploads']));  */
		// var_dump($_POST);
		// var_dump($_FILES);				 
		$upp =  false;
		if(isset($_POST['claimS'])){   
			// var_dump($imageUploadFile);						
			/***						
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/estimate');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/images');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/ems');
			$images_path = realpath(Yii::app()->basePath . '/../uploadtoclaim/additional');
			**/
			if(isset($_FILES['files'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_POST['claimS'];
				$mode->estimate = $_FILES['files']['name']['0'];
				move_uploaded_file($_FILES["files"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/estimate/'. $_FILES["files"]["name"]['0']);
				if($mode->save()){
					$upp = $upp || true;
				};
			}
			if(isset($_FILES['efiles'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_POST['claimS'];
				$mode->ems = $_FILES['efiles']['name']['0'];
				move_uploaded_file($_FILES["efiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/ems/'. $_FILES["efiles"]["name"]['0']);
				if($mode->save()){
					$upp = $upp || true;
				};
			}
			if(isset($_FILES['ifiles'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_POST['claimS'];
				$mode->images = $_FILES['ifiles']['name']['0'];
				move_uploaded_file($_FILES["ifiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/images/'. $_FILES["ifiles"]["name"]['0']);
				if($mode->save()){
					$upp = $upp || true;
				};
			}
			if(isset($_FILES['sfiles'])){
				$mode = new Claimuploads;
				$mode->claim_id = $_POST['claimS'];
				$mode->additional_files = $_FILES['sfiles']['name']['0'];
				move_uploaded_file($_FILES["sfiles"]["tmp_name"]['0'],dirname(dirname(dirname(__FILE__))) .'/uploadtoclaim/additional/'. $_FILES["sfiles"]["name"]['0']);
				if($mode->save()){
					$upp = $upp || true;
				};
			}
			if($upp){
				Yii::app()->user->setFlash('success','File Uploaded Successfully');                         
				echo 'success';
				// $this->redirect(array('claimuploads/create'));
			}
		}
		$claimid=$_REQUEST['Claim_id'];
		$claim=new Claim;        
		$q=new CDbCriteria;
		$q->compare("t.id",$claimid);                       
		$claims=$claim->find($q);
		$this->render('create',array('model'=>$model,'claim'=>$claims,));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		// $this->performAjaxValidation($model);

		if(isset($_POST['Claimuploads']))
		{
			$model->attributes=$_POST['Claimuploads'];
			if($model->save())
				$this->redirect(array('view','id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$this->loadModel($id)->delete();

		// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
		if(!isset($_GET['ajax']))
			$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('Claimuploads');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model=new Claimuploads('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['Claimuploads']))
			$model->attributes=$_GET['Claimuploads'];

		$this->render('admin',array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 * @return Claimuploads the loaded model
	 * @throws CHttpException
	 */
	public function loadModel($id)
	{
		$model=Claimuploads::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param Claimuploads $model the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='claimuploads-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
